﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ZPLDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int result = 0;
            zpl_dll dll = new zpl_dll();

            //创建一个打印机 
            result = zpl_dll.PrinterCreator(ref dll.printer, "CP30");

            if (0 == result)
            {
                if ((result = zpl_dll.PortOpen(dll.printer, "USB")) == 0)
                {
                    //开始
                    result = zpl_dll.ZPL_StartFormat(dll.printer);

                    //设置打印浓度
                    result = zpl_dll.ZPL_SetPrintDarkness(dll.printer, 20);

                    //设置是否翻转打印
                    result = zpl_dll.ZPL_SetPrintOrientation(dll.printer, 0);

                    //打印图片
                    result = zpl_dll.ZPL_PrintImage(dll.printer, 100, 30, "D:\\1.bmp");

                    //打印Pdf417
                    result = zpl_dll.ZPL_Pdf417(dll.printer, 100, 180, 0, 2, 20, 2, 5, 5, 'N', "0010101101");

                    //打印BarCode39条码
                    result = zpl_dll.ZPL_BarCode39(dll.printer, 100, 300, 0, 3, 50, 'Y', 'Y', 'Y', "66886868");

                    //打印CodeEan8条码
                    result = zpl_dll.ZPL_CodeEan8(dll.printer, 100, 400, 0, 3, 60, 'Y', 'Y', "90381010");

                    //打印UPC-E
                    result = zpl_dll.ZPL_UpceCode(dll.printer, 100, 500, 0, 3, 50, 'N', 'N', "001100");

                    //打印UPC-A
                    result = zpl_dll.ZPL_UpcaBarcode(dll.printer, 100, 600, 0, 3, 50, 'Y', 'Y', 'N', "47631664454");

                    //打印UPC扩展条码
                    result = zpl_dll.ZPL_UpcExtensions(dll.printer, 100, 700, 0, 3, 50, 'Y', 'Y', "01234");

                    //打印二维码
                    result = zpl_dll.ZPL_QRCode(dll.printer, 100, 800, 0, 1, 3, 'M', 7, "1000000001");
                   
                    //打印汉字 
                    result = zpl_dll.ZPL_SetChangeFontEncoding(dll.printer, 14);
                    result = zpl_dll.ZPL_Text(dll.printer, 100, 900, 16, 0, 40, 40, "你好");
                    result = zpl_dll.ZPL_Text(dll.printer, 300, 900, 16, 0, 40, 40, "hello");
                    result = zpl_dll.ZPL_Text(dll.printer, 500, 900, 16, 0, 40, 40, "こんにちは");

                    //打印图形圆圈
                    result = zpl_dll.ZPL_GraphicCircle(dll.printer, 100, 1000, 150, 5);

                    //打印图形椭圆
                    result = zpl_dll.ZPL_GraphicEllipse(dll.printer, 300, 1000, 150, 100, 10);

                    //打印对角线
                    result = zpl_dll.ZPL_GraphicDiagonalLine(dll.printer, 500, 1000, 0x52, 50, 50, 20);

                    //打印图形框
                    result = zpl_dll.ZPL_GraphicBox(dll.printer, 100, 1200, 100, 100, 60, 3);

                    //打印符号
                    result = zpl_dll.ZPL_GraphicSymbol(dll.printer, 300, 1200, 0, 200, 200, "A");

                    //DirectIO 使用示例
                    byte[] str = new byte[] { 0x53, 0x45, 0x4c, 0x46, 0x54, 0x45, 0x53, 0x54, 0x0d, 0x0a };
                    result = zpl_dll.DirectIO(dll.printer, str, 10, str, 0, ref result);

                    //结束
                    result = zpl_dll.ZPL_EndFormat(dll.printer);

                    //删除打印机
                    result = zpl_dll.PortClose(dll.printer);

                    //销毁
                    result = zpl_dll.PrinterDestroy(dll.printer);
                }
                else
                {
                    MessageBox.Show("Usb Device not found.please confirm the target printer is connected and power on.");
                }

            }
        }
    }
    public class zpl_dll
    {
        [DllImport("ZPL_SDK")]
        public static extern int PrinterCreator(ref int printer, string model);
        [DllImport("ZPL_SDK")]
        public static extern int PrinterCreatorS(string model);
        [DllImport("ZPL_SDK")]
        public static extern int PrinterDestroy(int printer);
        [DllImport("ZPL_SDK")]
        public static extern int PortOpen(int printer, string portSetting);
        [DllImport("ZPL_SDK")]
        public static extern int PortClose(int printer);
        [DllImport("ZPL_SDK")]
        public static extern int WriteData(int printer, byte[] writeData, int writeNum);
        [DllImport("ZPL_SDK")]
        public static extern int ReadData(int printer, byte[] readData, int readNum, ref int preadedNum);
        [DllImport("ZPL_SDK")]
        public static extern int DirectIO(int printer, byte[] writeData, int writeNum, byte[] readData, int readNum, ref int preadedNum);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_StartFormat(int printer);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_EndFormat(int printer);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetChangeFontEncoding(int printer, int encodeType);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_Text(int printer, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_Text_Block(int printer, int xPos, int yPos, int fontNum, int orientation, int fontWidth, int fontHeight, int textblockWidth, int textblockHeight, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_BarCode39(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_Pdf417(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, int securityLevel, int column, int rows, char truncate, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_CodeEan8(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_UpceCode(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_QRCode(int printer, int xPos, int yPos, int orientation, int model, int dpi, char errLevel, int maskMode, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_UpcExtensions(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_UpcaBarcode(int printer, int xPos, int yPos, int orientation, int moduleWidth, int codeHeight, char line, char lineAboveCode, char digit, string text);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetChangeCaret(int printer, char charactor);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetChangeDelimiter(int printer, char charactor);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetChangeTilde(int printer, char charactor);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_GraphicBox(int printer, int xPos, int yPos, int width, int height, int thickness, int rounding);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_GraphicCircle(int printer, int xPos, int yPos, int diameter, int thickness);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_GraphicDiagonalLine(int printer, int xPos, int yPos, int orientation, int width, int height, int thickness);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_GraphicEllipse(int printer, int xPos, int yPos, int width, int height, int thickness);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_PrintImage(int printer, int xPos, int yPos, string imgName);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_GraphicSymbol(int printer, int xPos, int yPos, int orientation, int width, int height, string type);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetDiagnosticsMode(int printer, int isEnable);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetPrintOrientation(int printer, int orientation);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetPrintRate(int printer, int printSpeed, int slewSpeed, int backfeedSpeed);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_SetPrintDarkness(int printer, int darkness);
        [DllImport("ZPL_SDK")]
        public static extern int ZPL_PrintConfigurationLabel(int printer);

        public int printer;
    }
}